// User defined constants
#define ERASE               0x4042
#define NUM_DATA_EE_PAGES   31
#define PROGRAM_ROW         0x4001
#define PROGRAM_WORD        0x4003

// Internal constants
#define	NUMBER_OF_INSTRUCTIONS_IN_PAGE  512
#define	NUMBER_OF_INSTRUCTIONS_IN_ROW   64
#define NUMBER_OF_ROWS_IN_PAGE          (NUMBER_OF_INSTRUCTIONS_IN_PAGE \ NUMBER_OF_INSTRUCTIONS_IN_ROW)

extern int  ReadPMHigh(int);
extern int  ReadPMLow(int);
extern void UnlockPM(void);
extern int  WritePMHigh(int, int);
extern int  WritePMHighB(int, int);
extern int  WritePMLow(int, int);
extern int  WritePMLowB(int, int);

void            UnlockWrite         (void);
void            ErasePage           (unsigned char page);
void            DataEEInit          (void);
unsigned int    DataEERead          ();
void            DataEEWrite         (unsigned int data);

